﻿using System.Collections.Generic;
using System.Linq;
using System.Web.Mvc;

namespace HIPS.Web.UI.ViewModels.PcehrView
{

    /// <summary>
    /// View model for selecting a hospital and displaying its current patients.
    /// </summary>
    /// <history>
    ///   <change user="David Sampson (Chamonix)" date="25 November 2013">Initial version.</change>
    /// </history>
    public class PatientsViewModel : PcehrViewModelBase
    {

        #region Properties

        /// <summary>
        /// Gets or sets the list of hospitals available for selection.
        /// </summary>
        /// <history>
        ///   <change user="David Sampson (Chamonix)" date="25 November 2013">Initial version.</change>
        /// </history>
        public IEnumerable<SelectListItem> Hospitals { get; internal set; }
        
        /// <summary>
        /// Gets or sets the list of patients for a selected hospital.
        /// </summary>
        /// <history>
        ///   <change user="David Sampson (Chamonix)" date="25 November 2013">Initial version.</change>
        /// </history>
        public List<PatientViewModel> Patients { get; internal set; }

        #endregion

        #region Constructors

        /// <summary>
        /// Constructor.
        /// </summary>
        /// <history>
        ///   <change user="David Sampson (Chamonix)" date="25 November 2013">Initial version.</change>
        /// </history>
        public PatientsViewModel()
        {
            this.Hospitals = Enumerable.Empty<SelectListItem>();
            this.Patients = new List<PatientViewModel>();
        }

        #endregion

    }
}

